<?php
/* include the ACS class page */
require_once("../../classes/ACS.php");
/******* Code For reading data from excel file format and writing it into html file format**********/

/* Step 1: create object of the ACS class */
$ACS=new ACS();
if(isset($_POST['import']))
{
	// set whether first row is header or not (true or false)	
	$ACS->isFirstRowHeader=$_POST['firstRowHeader'] == 'true' ? true : false;
	//set the style of the html file
	$ACS->htmlTDStyle=$_POST['CssStyle'];
	//set the excel format (Excel2007 or Excel5)
	$ACS->excelFormat=$_POST['excelType'];
	// save the file on Specific location or display in browser (browser or save)
	$ACS->fileOutputMode=$_POST['browserMode'];
	// set the output path where file want to save converted file format
	$outputPath=$_POST['outputPath'];
	
	
	// using the ACS script to upload file and get the upload file path, you can use your own file upload code  also
	$ACS->replaceOlderFile=true;//replace old file if already exists there
	if($ACS->fileUpload($_FILES['uploadXsl'],"",$ACS->maxSize,array("xls","xlsx")))
	{  
		//get the path of the uploaded file	
		$path=$ACS->uploadedFileName;
		
		/* Step 3: call the convert method to reading the excel Format and generate file in html format*/			
		$ACS->convert("excel","html",$path,$outputPath);
		
		if(!isset($ACS->error))
		{
			$message="<div class='success'>Operation done successfully</div>";
		}
		else
		{
			$message="<div class='error'>There is error in operation. Please check error message: ".$ACS->error."</div>";	
		}
		
		/*Debug Operations - Uncomment below code lines to debug values */
		/*echo $ACS->error; //To display any error occured
		echo $ACS->messages; //It displays various messages at various points to check where code breaks
		print_r($ACS->inputDataArray);// To print the array of data generated after reading the csv file
		print_r($ACS->formattedDataArray);// To print the formatted array of data generated by code before final operation*/
	}
	else
	{
		echo $ACS->error;
	}	
}
require_once("../../header.php");
?>
<h4>HTML Generate From Excel</h4><hr />
<div class="from">
<?php if(isset($message)) echo $message; ?>
<form method="post" enctype="multipart/form-data">
<div class="formRow">
<div class="formLabel">Upload Excel</div><div class="formField"><input type="file" id="File1" name="uploadXsl"  required="required"/></div>
</div>
<div class="formRow">
      <div class="formLabel">Excel Format</div>
      <div class="formField">
        <select name="excelType">
          <option value="Excel5">Excel5</option>
          <option value="2007">Excel2007</option>
        </select>
      </div>
    </div>
<div class="formRow">
<div class="formLabel">Is First Row As Header</div><div class="formField"><input type="radio" name="firstRow" value="true" checked="checked"/>&nbsp;&nbsp;True&nbsp;&nbsp;&nbsp;<input type="radio" name="firstRow" value="false"/>&nbsp;&nbsp;False</div>
</div>
<div class="formRow">
      <div class="formLabel">CSS Style</div>
      <div class="formField">
        <input type="text" name="CssStyle" />
      </div>
    </div>
<div class="formRow">
<div class="formLabel">File Output Mode</div><div class="formField"><input type="radio" name="browserMode" value="save"/>&nbsp;&nbsp;Save file on the server&nbsp;&nbsp;&nbsp;<input type="radio" name="browserMode" value="browser" checked="checked"/>&nbsp;&nbsp;Output in Browser</div>
</div>
<div class="formRow">
<div class="formLabel">Output File Name</div><div class="formField"><input type="text" name="outputPath" value="file.html" /></div>
</div>
<div class="formRow">
<div class="formLabel"></div>
<div class="formField submit">
 <input type="submit" id="save" name="import" value="Save"/>
 <input type="reset" name="reset" /></div>
</div>
</form>
</div>
<div class="htmloutput">
<?php 
if(isset($_POST['import']))
{
	if($_POST['browserMode']=="browser")
		echo $ACS->outputHTML;
}
?>
</div>
<div class="code">
<h5 class="head5">Code For HTML</h5>
<pre>
<code data-language="php">&lt;?php
/* include the ACS class page */
   require_once("../../classes/ACS.php");

/* Step 1: create object of the ACS class */
   $ACS=new ACS();

/* Step 2: call the convert method for reading the csv Format and inserting data in database  */
/* $excelFileLocation  = location of the excel file (i.e. complete path of the uploaded excel file)  */
/* $outputFileLocation = location of the output file (i.e. complete path of the output file)  */	
   $ACS->convert("excel","html",$excelFileLocation,$outputFileLocation);
?&gt;    
</code>
</pre>
</div>